import { I18nManager, StyleSheet } from "react-native";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";

const imgContHeight = dpr(270);

export const itemCarouselStyle = StyleSheet.create({
    imageSize: {
        height: dpr(270),
        width: dpr("wf"),
        transform: [{ scaleX: I18nManager.isRTL ? -1 : 1 }]
    },
    singleImgCont: {
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        width: dpr("wf"),
        height: imgContHeight,
        backgroundColor: "#F3F3F3",
        zIndex: -1,
    },
    leftIcon: {
        position: "absolute",
        left: dpr(10),
        paddingLeft: dpr(10),
        top: imgContHeight / 2 - dpr(30),
        paddingTop: dpr(30),
        zIndex: 1,
        height: dpr(70),
        width: dpr(30),
    },
    rightIcon: {
        position: "absolute",
        right: dpr(10),
        paddingLeft: dpr(10),
        top: imgContHeight / 2 - dpr(30),
        paddingTop: dpr(30),
        zIndex: 1,
        height: dpr(70),
        width: dpr(30),
    },
    indidatorCont: {
        width: dpr(60),
        flexDirection: "row",
        justifyContent: "center",
        position: "absolute",
        left: (dpr("wf") - dpr(60)) / 2,
        top: dpr(250),
    },
    indicator: {
        height: dpr(8),
        width: dpr(8),
        borderRadius: 50,
        backgroundColor: "#89898959",
        marginHorizontal: dpr(4),
    },
    activeIndicator: {
        backgroundColor: '#FCCA19',
        width: dpr(30),
    }
});
